/** @file   glyph.cpp
 * @brief   Implementation of Glyph - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "glyph.h"


namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
Glyph::Glyph() :
  m_character( 0 ),
  m_index( 0 ),
  m_width( 0 ),
  m_pGfx( 0 )
{
}



Glyph::Glyph( int index, int c, int w ) :
  m_character( c ),
  m_index( index ),
  m_width( w ),
  m_pGfx( 0 )
{
}



/** Destructor
 */
Glyph::~Glyph()
{
  if ( m_pGfx != 0 ) {
    destroy_bitmap( m_pGfx );
    m_pGfx = 0;
  }
}




///
/// Public methods
/// ==============




///
/// Getter methods
/// ==============

/** Returns the character
 */
int Glyph::character()  const
{
  return m_character;
}



/** Returns the width of this glyph
 */
int Glyph::width() const
{
  return m_width;
}



/** Returns the bitmap
 */
BITMAP* Glyph::gfx() const
{
  return m_pGfx;
}


///
/// Private or Protected methods
/// ============================

/** Sets the graphics
 */
void Glyph::setGfx( BITMAP* pB )
{
  m_pGfx = pB;
}


} // end of namespace
